import java.io.*;
import java.util.*;
import java.math.*;

public class D implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private boolean solveOne() throws IOException {
		int n = nextInt();
		if (n == 0)
			return false;
		int waterCost = nextInt();
		int[] waterProfit = new int[n], fixCost = new int[n], fixProfit = new int[n], result = new int[n];
		for (int i = 0; i < n; i++) {
			waterProfit[i] = nextInt();
			fixCost[i] = nextInt();
			fixProfit[i] = nextInt();
			result[i] = nextInt();
		}
		double l = 0.0, r = 1e5;
		for (int it = 0; it < 150; it++) {
			double p0 = l + (r - l) / 3.0;
			double p1 = r - (r - l) / 3.0;
			if (getCost(n, waterCost, waterProfit, fixCost, fixProfit, result,
					p0) > getCost(n, waterCost, waterProfit, fixCost,
					fixProfit, result, p1)) {
				l = p0;
			} else {
				r = p1;
			}
		}
		double finalCost = getCost(n, waterCost, waterProfit, fixCost,
				fixProfit, result, (l + r) * 0.5);
		out.println(finalCost);
		return true;
	}

	private double getCost(int n, int waterCost, int[] waterProfit,
			int[] fixCost, int[] fixProfit, int[] result, double p) {
		double cost = p * waterCost;
		for (int i = 0; i < n; i++) {
			double current = waterProfit[i] * p;
			double remain = result[i] - current;
			if (remain > 0) {
				double howMuch = remain / fixProfit[i];
				cost += howMuch * fixCost[i];
			}
		}
		return cost;
	}

	private void solve() throws IOException {
		while (solveOne())
			;
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new D().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
